% ALPHA ENGINE DEFINITION
% Generated 21-Mar-2023 13:58:45

% SUGGESTED CITATION:
% Toyota 2.5L TNGA Prototype Hybrid Engine from 2017 Vienna Paper - ALPHA Map Package. Version 2023-03. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2023.


% Constructor
engine = class_REVS_engine();
engine.name =  'Toyota 2.5L TNGA Prototype Hybrid Engine from 2017 Vienna Paper'; 
engine.source_filename = mfilename;
engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  2.5; 
engine.num_cylinders =  4; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;

% Maximum Torque Curve
engine.full_throttle_speed_radps = [	     0.0000000000000000	;     83.775804095727807	;     125.66370614359172	;     136.13568165555770	;     167.55160819145561	;     208.79508099315544	;     332.52549929353512	;     463.12982986715770	;     598.03035541520774	;     609.20046255815828	;     639.66048568606618	;     670.12050881397420		]; 
engine.full_throttle_torque_Nm = [	     0.0000000000000000	;     100.00000000000000	;     159.00000000000000	;     170.00000000000000	;     187.84552800000000	;     198.82113799999999	;     219.34959300000000	;     220.97560999999999	;     219.55284599999999	;     211.42276400000000	;     181.21951200000001	;     0.0000000000000000		]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [	     0.0000000000000000	;     105.03391438501875	;     373.95424553230504	;     470.50585975263135	;     603.18578948924028	;     670.12050881397420		]; 
engine.closed_throttle_torque_Nm = [	    -15.948686146731134	;    -22.000000000000000	;    -31.699999999999999	;    -38.600000000000001	;    -50.700000000000003	;    -54.556306762306079		]; 

% Fuel Map
engine.fuel_map_speed_radps = [	     0.0000000000000000	    52.359877559829883	    78.539816339744831	    104.71975511965977	    130.89969389957471	    157.07963267948966	    183.25957145940458	    209.43951023931953	    235.61944901923448	    261.79938779914943	    287.97932657906438	    314.15926535897933	    340.33920413889422	    366.51914291880917	    418.87902047863906	    471.23889803846896	    523.59877559829886	    575.95865315812875	    628.31853071795865	    680.67840827778844		]; 
engine.fuel_map_torque_Nm = [	    -57.284122100421385	;    -39.642061050210692	;    -22.000000000000000	;    -11.876016250000001	;    -1.7520325000000021	;     8.3719512499999986	;     18.495934999999996	;     28.619918750000004	;     38.743902499999997	;     48.867886249999998	;     58.991869999999992	;     69.115853749999999	;     79.239837500000007	;     89.363821250000001	;     99.487804999999994	;     109.61178874999999	;     119.73577250000000	;     129.85975625000000	;     139.98373999999998	;     150.10772374999999	;     160.23170750000000	;     170.35569124999998	;     180.47967500000001	;     190.60365874999999	;     200.72764250000000	;     210.85162624999998	;     220.97560999999999	;     232.02439050000001		]; 
engine.fuel_map_gps = [
 -0.042091507425468654	  -0.17535474882008983	  -0.21179231276461122	  -0.23105549215901164	  -0.24794739469172783	  -0.26239714655874735	  -0.27458159173781166	  -0.28486707157942887	  -0.29366071682131228	  -0.30129087821669676	  -0.30795814405832073	  -0.31374300937648225	  -0.31864204476237679	  -0.32261090446585072	  -0.32615239537494517	  -0.32157316314811019	  -0.30937403881191572	  -0.29058620229444315	  -0.26685629101408503	  -0.24107251486891099	;
 -0.022232108742018988	 -0.097659349845480123	  -0.10690162786550036	  -0.11315154693317467	  -0.11496322934176968	  -0.11293129599991276	  -0.10816617781838796	  -0.10138343123574638	 -0.092834660896413221	 -0.082527693731688320	 -0.070408848322744563	 -0.056443008444800616	 -0.040631408234576817	 -0.023012714211254233	  0.019979852848951252	  0.074406557382498920	   0.13597500119599845	   0.19916331994103745	   0.26072882438983752	   0.32017115104599375	;
-0.0055964168915317207	-0.0014623543278392034	 0.0023350548589135562	 0.0067253956453464173	  0.021330096759712362	  0.039065972626842020	  0.058794124878352276	  0.081047819445809466	   0.10628466845924209	   0.13463121387107702	   0.16601933508085623	   0.20031040778097198	   0.23734692409724870	   0.27695535702965002	   0.36678507089184514	   0.47082907257167828	   0.58183789404401542	   0.68994944593050456	   0.78761733511884391	   0.87970002055239327	;
 0.0028565833467982232	  0.050028011966125802	  0.070105150291159574	  0.086606165094543011	   0.10434322032614461	   0.12621497161276546	   0.15278993912062319	   0.18383168555456958	   0.21904527582313066	   0.25819685620334459	   0.30107057215586819	   0.34743884754961957	   0.39705708037089926	   0.44965704512215054	   0.56685470987728215	   0.69899757151906006	   0.83738749927102718	   0.97151258705204702	    1.0887014163424953	    1.2001996127490446	;
  0.018448872330816546	  0.092540090267535249	   0.13166947282809327	   0.15811467967889919	   0.18189824793161877	   0.21060394703474414	   0.24531704627041354	   0.28561472589839160	   0.33101335890644956	   0.38115808219573888	   0.43574828454452053	   0.49447336021926414	   0.55698844594753294	   0.62290226012358985	   0.76796839745932544	   0.92792329677157115	    1.0924114085384218	    1.2517757964108454	    1.3887293928576376	    1.5208980560491074	;
  0.028815462766371328	   0.12086208287648485	   0.16822577153522314	   0.20975388699881492	   0.24935983812254456	   0.29067907982505448	   0.33595676533693125	   0.38632078555974869	   0.44217065370012487	   0.50348692852506094	   0.57003557406159244	   0.64146632770532452	   0.71732928686083153	   0.79705572708975814	   0.97081932886059430	    1.1581663591383655	    1.3467448446731554	    1.5273145428468580	    1.6878253396836687	    1.8428225608354527	;
  0.033978851630332929	   0.15016982926904987	   0.20449949503515574	   0.25590371381695987	   0.31150682498150345	   0.36707127268520656	   0.42437850493741164	   0.48568717333547318	   0.55242030318420099	   0.62516991060720561	   0.70396517035542838	   0.78853737672226387	   0.87836283802482873	   0.97260322222716067	    1.1762554519553556	    1.3902236157270438	    1.6009138763942572	    1.8014470886737353	    1.9872759724311053	    2.1674335740113113	;
  0.033530032590706700	   0.17700300480296904	   0.24651068963970715	   0.31028859140538917	   0.37503709562426396	   0.44202997158300777	   0.51130685185349878	   0.58405812431850590	   0.66197632707942533	   0.74636191777239647	   0.83771414843745440	   0.93597826750124813	    1.0405383465200453	    1.1501142476849660	    1.3851694530850422	    1.6243101819198151	    1.8556989832609352	    2.0771563209780206	    2.2891857577050212	    2.4966907516051218	;
  0.028272317315513516	   0.19758284919206817	   0.27937838450024260	   0.35875720934217259	   0.43739714950569880	   0.51711331245640646	   0.59867693874653849	   0.68298173081556379	   0.77186811593760851	   0.86764936952618366	   0.97182897359046572	    1.0845365699893490	    1.2046022611298064	    1.3301546622055755	    1.5981768053166916	    1.8600332127400774	    2.1116695135398240	    2.3561955394987697	    2.5959635423249323	    2.8330672378018580	;
  0.019726527525459597	   0.21427863092637597	   0.30948557555346345	   0.40383792164796578	   0.49779272489822723	   0.59221236773352903	   0.68769644883836689	   0.78457407993674000	   0.88428574199544052	   0.99042125321756036	    1.1076690706155086	    1.2359220736298602	    1.3715930747193725	    1.5133337367885253	    1.8147748136979933	    2.0961254181191533	    2.3691518828775218	    2.6399196694675258	    2.9100524898451283	    3.1794458280318345	;
  0.010334107835381901	   0.23019876327308431	   0.33912487691051074	   0.44786020663685949	   0.55694177767941599	   0.66704080310659064	   0.77820157446064930	   0.89026625836553985	    1.0025924000657889	    1.1180567957896277	    1.2484764667916470	    1.3928607906240644	    1.5423405501732661	    1.7010397818428311	    2.0315465468351932	    2.3306708481029581	    2.6285410995922396	    2.9297070444265350	    3.2338441014264516	    3.5389505489366622	;
 0.0032026031291781444	   0.24769138906732896	   0.37002095045270267	   0.49256635835103341	   0.61594295038346492	   0.74170413033400373	   0.86841850180989322	   0.99837567462728072	    1.1285597210103031	    1.2608824286023321	    1.4025346544446180	    1.5548353800062515	    1.7187323665505445	    1.8963597848616272	    2.2392998408881049	    2.5622697199495246	    2.8906343360474729	    3.2270924748042917	    3.5696534611073756	    3.9147723812143975	;
 0.0017634852054018177	   0.26840925313204517	   0.40349195737655358	   0.53950427707120807	   0.67680308730551297	   0.81660067327121444	   0.95727547303669525	    1.1021215075529931	    1.2510079091188819	    1.4009256464986304	    1.5506022426418506	    1.7080585294953510	    1.8788866662054708	    2.0606185708580602	    2.4323487118868390	    2.7918381900849725	    3.1566700947543853	    3.5337626223645517	    3.9197021837954025	    4.3100145351911472	;
 0.0094208078977554306	   0.29377466403933022	   0.44022249257704532	   0.58908959366824776	   0.74010353663483097	   0.89158785836322285	    1.0429582435655325	    1.1974613910680929	    1.3595123019787236	    1.5230597258745453	    1.6831447857720405	    1.8507828530854813	    2.0309562554128364	    2.2224565308131430	    2.6244839921033827	    3.0223446472373467	    3.4283114704896458	    3.8515448724506460	    4.2861225214474254	    4.7275486212351110	;
  0.029012092366072811	   0.32556282332713826	   0.48059379678919029	   0.63944305847844995	   0.80149639634876990	   0.96495470024519858	    1.1277072086192985	    1.2925559940449978	    1.4653006390752614	    1.6416282052719797	    1.8157699060605019	    1.9959501171087506	    2.1883920785074573	    2.3931526068714302	    2.8229610946240977	    3.2577230988412254	    3.7081570166035567	    4.1823626440060693	    4.6710375402013682	    5.1698503293938467	;
  0.061999943997695608	   0.36616895477505867	   0.52613666614843979	   0.69146913337511506	   0.86254576137250583	    1.0379961521284682	    1.2127161210332758	    1.3884333863623521	    1.5712764134751818	    1.7592128656401782	    1.9483485940586960	    2.1440429108969230	    2.3518047704573153	    2.5708809923443865	    3.0293049288877363	    3.5021893694826445	    4.0001709052392025	    4.5280101948738265	    5.0767833197973840	    5.6387752785807512	;
   0.10767215936892217	   0.41898127292627801	   0.58045350476934332	   0.74822041083720703	   0.92597440455625235	    1.1124269883619693	    1.2989889808116091	    1.4870159123645568	    1.6805084106553871	    1.8785140053335627	    2.0789763940455805	    2.2901513528078499	    2.5157783254188786	    2.7523488686163304	    3.2437495849212561	    3.7601963766220381	    4.3098929385802931	    4.8929951984521560	    5.5062216725561228	    6.1352611845219531	;
   0.16277872263684359	   0.48722967425056651	   0.64929321512851490	   0.81478469819885979	   0.99070104194107866	    1.1825009769775341	    1.3838359029655511	    1.5869207455263865	    1.7933727227355476	    2.0026312064505261	    2.2144947332511804	    2.4386496867112393	    2.6782524556832858	    2.9338503260482920	    3.4656492848777218	    4.0367290552775152	    4.6441019452165877	    5.2818844480924181	    5.9627127377515565	    6.6590489057923721	;
   0.22219675455018967	   0.57064374622321201	   0.73842878735380957	   0.90303205428288991	    1.0715504556792794	    1.2605213710501861	    1.4664962064241993	    1.6807844222424437	    1.9045063229004213	    2.1276453890978413	    2.3517698925033326	    2.5889022269436817	    2.8423476921421149	    3.1146827759017133	    3.6952997780702823	    4.3375009998809695	    5.0098879831840017	    5.7002433854919703	    6.4497526359163260	    7.2084475598884010	;
   0.28085550699247286	   0.66383072943343757	   0.84856720864438517	    1.0270608629292388	    1.1984418737124694	    1.3726860610639167	    1.5647940378053418	    1.7753984538633851	    2.0111322599709149	    2.2517541960726581	    2.4934294793118839	    2.7457823227872984	    3.0141703807804938	    3.3004631499828387	    3.9433815491620892	    4.6684879971586417	    5.4126643051195407	    6.1572748864926545	    6.9697482668839230	    7.7803621529197553	;
   0.33575694063407224	   0.75978907566203124	   0.96967047485645730	    1.1776180122811386	    1.3777238538942698	    1.5507038355951865	    1.7210106354619081	    1.9187161584200019	    2.1471798410726892	    2.3950699749482895	    2.6538484473866819	    2.9191215159898389	    3.2014363718265977	    3.5042639432504350	    4.2252600683918864	    5.0339291408960660	    5.8530089800305207	    6.6698659914258229	    7.5214140090060857	    8.3708660034818845	;
   0.38607638402269562	   0.85404091980725871	    1.0882636100304839	    1.3215519656681141	    1.5490316693312807	    1.7590252458497322	    1.9425838607148136	    2.1335675621392087	    2.3467908907444790	    2.5894895602186692	    2.8486095745520208	    3.1184614970973588	    3.4129083564978493	    3.7430088709915399	    4.5554323850546057	    5.4340359895278674	    6.3237076763849167	    7.2144109986404663	    8.0969830959701738	    8.9762007921559128	;
   0.43167637187353736	   0.94284830380113205	    1.1980030208561825	    1.4514479656254571	    1.7001216973872315	    1.9400479387574756	    2.1645913196602269	    2.3855133821786048	    2.6151058411612160	    2.8535348811105776	    3.1023024357065201	    3.3709513570967680	    3.6841127171204500	    4.0732694844155812	    4.9447634178012230	    5.8631685122651920	    6.8130599487842165	    7.7739772160810769	    8.6851682194995519	    9.5927979772498304	;
   0.47234204059728047	    1.0240590060100285	    1.2980980482398263	    1.5697467782576968	    1.8364054664292671	    2.0948888346946157	    2.3443301080122358	    2.6031926095551290	    2.8819976607414528	    3.1471743165575496	    3.4115132144505886	    3.7070991127084589	    4.0637605143386137	    4.4993275385804301	    5.3729572216118759	    6.3116054554103345	    7.3092862557119345	    8.3303698274544544	    9.2748108600386168	    10.217392730624550	;
   0.50799735702950555	    1.0975812075801341	    1.3899938140570427	    1.6802144651537674	    1.9671466498930867	    2.2510867825964764	    2.5359180680418358	    2.8288237935390987	    3.1303823741659689	    3.4325959037892924	    3.7436562086893210	    4.0843099832007139	    4.4700384871815126	    4.8955748964120929	    5.7995205566349952	    6.7700815059597099	    7.8042551285612163	    8.8594234226258344	    9.8586099207345494	    10.847042665771662	;
   0.53915201399676738	    1.1650286828123952	    1.4766102686868772	    1.7874653537365617	    2.0982501778370217	    2.4109450043872211	    2.7284887310647323	    3.0528254936322021	    3.3846429377688896	    3.7263519879465306	    4.0835805205093259	    4.4639188468847708	    4.8707111250911481	    5.2994650165841444	    6.2285372808666608	    7.2320153552114235	    8.2956673961303249	    9.3796518667782482	    10.435866995209251	    11.478973728076207	;
   0.56708166995021181	    1.2288927268747372	    1.5608123574436976	    1.8940958837725836	    2.2304249082868184	    2.5719859948316426	    2.9207439018438017	    3.2780405197426585	    3.6457087449202832	    4.0268070664094173	    4.4237631235318808	    4.8373176876418293	    5.2665603441622846	    5.7102831602146331	    6.6618840006666558	    7.6944125432371804	    8.7843347649016188	    9.8985044074728137	    11.009005041702149	    12.111385527196683	;
   0.59575764758123051	    1.2969795961226926	    1.6518957942983621	    2.0105360290712087	    2.3751403838605114	    2.7479122504971558	    3.1308075087153764	    3.5256894740047340	    3.9342908163010075	    4.3573576940172059	    4.7936917132619072	    5.2406899438468164	    5.6964537338868313	    6.1612764290315027	    7.1380528800902656	    8.1987949541971616	    9.3162260587354169	    10.465218854015697	    11.632641397130280	    12.801407855218397	]; 

% Fuel Properties
engine.fuel = class_REVS_fuel('MTE_GASOLINE');

% Idle Speed
engine.idle_target_speed_radps = class_REVS_dynamic_lookup;
engine.idle_target_speed_radps.axis_1.signal =  'eng_runtime_sec'; 
engine.idle_target_speed_radps.axis_1.breakpoints = [	     0.0000000000000000	    10.000000000000000		]; 
engine.idle_target_speed_radps.table = [	     60.737457969402662	    60.737457969402662		]; 

% Calibration Adjustment Factors
engine.variant =  'basic engine'; 
